*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file for Nids Wave 2

* THIS IS 5th INCOME DO FILE - PRE-IMPUTATION AGGREGATION DO FILE: 5 OF 7
* THIS DO FILE AGGREGATES THE PRE-IMPUTATION INCOME VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

version 12.0

*=====================================================================================================================================

************************************
*PRE-IMPUTATION AGGREGATION DO FILE*
************************************

*THIS DO FILE AGGREGATES THE PRE-IMPUTATION INCOME VARIABLES

set more off

use "$DataOUT\prepdata.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------

*********************************
*Aggregating without imputations*
**********************************

*Total labour market income for smooth
egen pi_labourincome=rowtotal(fwag cwag swag cheq bonu help prof extr)
replace pi_labourincome=. if pi_labourincome==0
gen lnpi_labourincome=ln(pi_labourincome)

*Government income 
egen pi_governmentincome=rowtotal(spen dis chld fost cdep)
replace pi_governmentincome=. if pi_governmentincome==0
gen lnpi_governmentincome=ln(pi_governmentincome)

*Other government income
egen pi_otherincome=rowtotal(uif comp)
replace pi_otherincome=. if pi_otherincome==0
gen lnpi_otherincome=ln(pi_otherincome)

*Investment income from stocks, loans, rentals, private pensions, retirement annuities...
egen pi_investmentincome=rowtotal(indi rnt ppen)
replace pi_investmentincome=. if pi_investmentincome==0
gen lnpi_investmentincome=ln(pi_investmentincome)

*Income of a capital nature
egen pi_capitalincome=rowtotal(inhe retr brid gift loan sale othe)
replace pi_capitalincome=. if pi_capitalincome==0
gen lnpi_capitalincome=ln(pi_capitalincome)

*Remittances
gen pi_remittanceincome=remt
gen lnpi_remittanceincome=ln(pi_remittanceincome)

*Household-level income categories
sort w2_hhid

*Household income from subsistence agriculture
egen temp=rowtotal(opro plot), m
egen pi_hhagric=sum(temp), by(w2_hhid)
drop temp
label variable pi_hhagric "Household monthly income from subsistence agriculture, no imputations"

*Household income from the labour market
egen pi_hhwage=sum(pi_labourincome), by(w2_hhid)
replace pi_hhwage=. if pi_hhwage==0
label variable pi_hhwage "Household monthly income from labour market, no imputations"

*Household income from government grants
egen pi_hhgovt=sum(pi_governmentincome), by(w2_hhid)
replace pi_hhgovt=. if pi_hhgovt==0
label variable pi_hhgovt "Household monthly income from government grants, no imputations"

*Household income from other government sources
egen pi_hhother=sum(pi_otherincome), by(w2_hhid)
replace pi_hhother=. if pi_hhother==0
label variable pi_hhother "Household monthly income from other government sources, no imputations"

*Household income from investments
egen pi_hhinvest=sum(pi_investmentincome), by(w2_hhid)
replace pi_hhinvest=. if pi_hhinvest==0
label variable pi_hhinvest "Household monthly income from investments, no imputations"

*Household income of a capital nature (not included in hhincome)
egen pi_hhcapital=sum(pi_capitalincome), by(w2_hhid)
replace pi_hhcapital=. if pi_hhcapital==0
label variable pi_hhcapital "Household monthly income of a capital nature, no imputations"

*Household income from remittances
egen pi_hhremitt=sum(pi_remittanceincome), by(w2_hhid)
replace pi_hhremitt=. if pi_hhremitt==0
label variable pi_hhremitt "Household monthly income from remittances, no imputations"

*Household income from imputed rent from owner-occupied housing
gen pi_hhimprent=rent_would
lab var pi_hhimprent "Imputed rent from owner-occupied housing, no imputations"

*Household total income with no imputations
egen pi_hhincome=rowtotal(pi_hhwage pi_hhgovt pi_hhother pi_hhinvest pi_hhremitt pi_hhagri pi_hhimprent), m
replace pi_hhincome=. if pi_hhincome==0
label variable pi_hhincome "Household monthly income - no imputations"

keep pid pi_*
sort pid
save "$DataOUT\pi_data.dta", replace

* OPENING DATASET CREATED IN PREVIOUS DO FILE "Program 9.3 - Income -  Performing Imputations for missing data on Income varaibles (4 of 7)"

use "$DataOUT\impdata.dta", clear
sort pid
merge 1:1 pid using "$DataOUT\pi_data.dta"
drop _merge
save "$DataOUT\impdata.dta", replace
erase "$DataOUT\pi_data.dta"

* end of do file
*=====================================================================================================================================

